// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : classMake[ camera.h ]			Auter : KENSUKE WATANABE
//														Data  : 2017/04/27
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2017/04/27
//
// ======== ======== ======== ======== ======== ======== ======== ========
#ifndef _CAMERA_H_
#define _CAMERA_H_

#include "scene.h"

#define CAM_NEAR (1.f)
#define CAM_FAR (2000.f)

// -------- -------- -------- -------- -------- -------- -------- --------
// NX
// -------- -------- -------- -------- -------- -------- -------- --------
class CSceneField;
class CCamera
{
public:
	
	typedef enum
	{
		NONE = 0,
		CONTROL_PLAYER,
		MAX
	}AT_OBJTYPE;

	CCamera();
	~CCamera() {};

	void Init(void);
	void Uninit(void);
	void Update(void);
	void Draw(void) {}

	void Set(void);
	void SetCamPos(D3DXVECTOR3 pos) { m_posCamera = pos; }
	void SetatObjType(AT_OBJTYPE atObjType) { m_atObjType = atObjType; }

	const D3DXVECTOR3 &GetRot(void)const { return m_rot; }
	const D3DXVECTOR3 &GetPos(void)const { return m_posCamera; }
	const D3DXVECTOR3 &GetPosAt(void)const { return m_posAt; }

	const D3DXMATRIX &GetView(void)const { return m_mtxView; }
	const D3DXMATRIX &GetProj(void)const { return m_mtxProj; }

	static D3DXVECTOR3* CalcScreenToWorld(D3DXVECTOR3* pout, int Sx, int Sy, float fZ,
		int Screen_w, int Screen_h, const D3DXMATRIX &View, const D3DXMATRIX &Prj);

	// Jɑ΂ړ
	static float BEFORE(const float &y) { return y; }						// O
	static float BACK(const float &y) { return y + D3DX_PI; }				// 
	static float RIGHT(const float &y) { return y - D3DX_PI * 0.5f; }		// E
	static float LEFT(const float &y) { return y + D3DX_PI * 0.5f; }		// 
	static float RBEFORE(const float &y) { return y - D3DX_PI * 0.25f; }	// E
	static float RBACK(const float &y) { return y - D3DX_PI * 0.75f; }		// E
	static float LBEFORE(const float &y) { return y + D3DX_PI * 0.25f; }	// 
	static float LBACK(const float &y) { return y + D3DX_PI * 0.75f; }		// 

	// J]
	void AddCamRoate(const float &rot);
	void SetLockAt(D3DXVECTOR3 lookAt);

private:
	float m_len;
	AT_OBJTYPE m_atObjType;
	CSceneField* m_pField;

	D3DXVECTOR3 m_rot;
	D3DXVECTOR3 m_posCamera;	// W
	D3DXVECTOR3 m_posAt;		// _
	D3DXVECTOR3 m_vecUp;		// 㕔
	D3DXMATRIX m_mtxView;		// r[s
	D3DXMATRIX m_mtxProj;		// vWFNVs
};

#endif